import unittest
import os
from nxg_common import set_python_env

class TestPythonEnv(unittest.TestCase):
    '''Basic unit test for nxg common'''
    def test_no_args(self):
        self.assertEqual(set_python_env(), [])
    
    def test_modules_only(self):
        self.assertEqual(set_python_env(modules="numpy,scipy"), ["module load numpy", "module load scipy"])
    
    def test_virtualenv_only(self):
        os.mkdir('test_venv')
        self.assertEqual(set_python_env(virtualenv='test_venv'), ["source test_venv/bin/activate"])
        os.rmdir('test_venv')
    
    def test_modules_and_virtualenv(self):
        os.mkdir('test_venv')
        self.assertEqual(set_python_env(modules="numpy", virtualenv='test_venv'), ["module load numpy", "source test_venv/bin/activate"])
        os.rmdir('test_venv')

if __name__ == '__main__':
    unittest.main()