###################################################################
## version 3 - RMSE, Pearson and #Spearman#, vs. motif length
## use as: R-2.9 --vanilla --args [input1] [output.file] < R-plot_pfsize.R

cmd_args = commandArgs(TRUE);

dpoints = cmd_args[1];
ograph = cmd_args[2]; 

options(warn=-1)

mat=read.delim(dpoints,head=F)
size = mat[,1]
rmse = mat[,2]
rmseE = mat[,3]
pea = mat[,4]
peaE = mat[,5]

minC=min(pea-peaE)
maxC=max(pea+peaE)
printarea=seq(from=minC, to=maxC, by=(maxC-minC)/1000)

minR=min(rmse-rmseE)
maxR=max(rmse+rmseE)
printarea2=seq(from=minR, to=maxR, by=(maxR-minR)/1000)

error.bar <- function(x, y, error, color) { arrows(x,y+error, x, y-error, col=color, angle=90, code=3, length=0.05, lwd=0.75)}

png(ograph,type="cairo1")

plot(size, rmse, ylim=range(printarea2), xlab="", ylab="", type="b", xaxt="n", yaxt="n", col = "blue", lwd="2", main="Motif length vs. Performance")
axis(1, at=size, labels=size)
axis(2, pretty(range(printarea2),10))
error.bar(size-0.02,rmse,rmseE,"blue")

par(new=T)

plot(size, pea, ylim=range(printarea), xlab="Motif length", xaxt="n", yaxt="n", ylab="", type="b", col = "red", lwd="2")
axis(4, pretty(range(printarea),10))
error.bar(size+0.02,pea,peaE,"red")

colors = c("blue","red")

legend(x="right",bty="n",inset=0.05,legend=c("RMSE (left y axis)", "Pearson (right y axis)"),fill=colors)

dev.off()


