# This is the script used to convert the comblib data files into a single
#   pickle file.
# TODO: Remove this after comblib predictor data is removed from
#    'djangotools/tool_data/MHCII/comblib'
import os
import re
import glob
import cPickle

original_dir = os.getcwd()
djangotools_dir = '/home/jivan/.projects/lji/djangotools'
data_dir = 'tool_data/MHCII/comblib'
data_dir_full_path = os.path.join(djangotools_dir, data_dir)
os.chdir(data_dir_full_path)
data_dict = {}

for filename in glob.glob('*-9.txt'):
    pattern = '(.*)-9.txt'
    m = re.search(pattern, filename)
    allele_name = m.group(1)
    key = allele_name
    with open(filename) as old_pickle_file:
        ignored_length = cPickle.load(old_pickle_file)
        matrix = cPickle.load(old_pickle_file)
        slope = cPickle.load(old_pickle_file)
        intercept = cPickle.load(old_pickle_file)
        geomean = cPickle.load(old_pickle_file)
        allele_data = {
            'matrix': matrix,
            'slope': slope,
            'intercept': intercept,
            'geomean': geomean,
        }

    data_dict[allele_name] = allele_data

os.chdir(original_dir)

with open('comblib_predictor_data_pre_2016-02-12.p', 'w+') as pickle_file:
    cPickle.dump(data_dict, pickle_file)
