import pkg_resources
import pickle

package_name = 'mhcii_netmhciipan_32_percentile_data'
pickle_foldername = 'netmhciipan_percentile_distribution'

class PercentileManager(object):
    ''' Provides access to percentile score distributions
        taking care of storage specifics.
    '''

    def get_distributions(self, allele):
        ''' Returns percentile distributions for the given allele.
            pickle file name example:
            netmhciipan_percentile_distribution/HLA-DQA10503-DQB10402.p
            netmhciipan_percentile_distribution/DRB1_0819.p
        '''
        pickle_filename = '%s/%s.p' % (pickle_foldername, allele)
        pickle_filepath = pkg_resources.resource_filename(package_name, pickle_filename)
        with open(pickle_filepath, 'rb') as pfile:
            score_distributions = pickle.load(pfile)
        return score_distributions

percentile_manager = PercentileManager()
