'''
Created on Oct 11, 2019
@author: Yan
The code coverage by tests is 100%. (__init__.py)  
'''
from unittest import TestCase
import unittest
from mhcii_netmhciipan_32_percentile_data import percentile_manager
'''
Name                                                                                                        Stmts   Miss  Cover
-------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/__init__.py                         1607    988    39%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/__init__.py                    0      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__about__.py        10      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__init__.py          3      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_compat.py          12      1    92%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_structures.py      41     17    59%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/specifiers.py      281    201    28%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/version.py         150     78    48%
mhcii_netmhciipan_32_percentile_data/__init__.py                                                               12      0   100%
tests.py                                                                                                       34      0   100%
-------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                        2150   1285    40%
'''


class PercentileManagerTests(unittest.TestCase):
    def test_basic(self):
        method_name = 'netmhciipan'
        allele_name = 'DRB1_0101'
        binding_length = 15
        key = (method_name, allele_name, binding_length)

        score_distributions = percentile_manager.get_distributions(allele_name)

        self.assertIn(key, score_distributions)
        score_distribution = score_distributions[key]

        self.assertEqual(len(score_distribution), 280)
        expected_distribution = [4.49, 5.22, 5.64, 5.82, 5.85, 6.34, 6.4, 6.72, 6.73, 7.01, 7.17, 7.25, 7.26, 7.33, 7.41, 7.56, 7.62, 7.72, 7.75, 7.8, 8.03, 8.17, 8.17, 8.23, 8.35, 8.45, 8.47, 8.67, 8.69, 8.7, 8.76, 8.8, 8.81, 8.85, 9.05, 9.09, 9.12, 9.18, 9.52, 9.52, 9.69, 9.7, 9.79, 9.88, 9.92, 10.26, 10.3, 10.44, 10.44, 10.58, 10.61, 10.66, 10.68, 10.69, 10.71, 10.72, 10.72, 10.8, 10.81, 10.83, 10.84, 10.9, 10.92, 10.94, 10.95, 11.0, 11.05, 11.05, 11.08, 11.12, 11.13, 11.15, 11.19, 11.24, 11.33, 11.46, 11.62, 11.7, 11.83, 11.91, 11.98, 12.0, 12.02, 12.13, 12.19, 12.2, 12.22, 12.23, 12.24, 12.31, 12.33, 12.35, 12.35, 12.41, 12.43, 12.43, 12.5, 12.53, 12.55, 12.57, 12.66, 12.96, 13.38, 13.83, 14.18, 14.81, 15.19, 15.43, 15.73, 15.93, 16.16, 16.63, 17.03, 17.25, 17.41, 17.63, 17.83, 18.08, 18.49, 18.74, 19.07, 19.45, 19.71, 20.18, 20.43, 20.84, 21.12, 21.5, 21.91, 22.27, 22.41, 22.7, 23.14, 23.45, 23.82, 24.28, 24.74, 25.13, 25.4, 25.9, 26.08, 26.34, 26.62, 26.87, 27.25, 27.59, 27.88, 28.17, 28.54, 28.82, 29.18, 29.48, 29.7, 29.89, 30.23, 30.4, 30.68, 31.08, 31.43, 31.69, 31.96, 32.25, 32.63, 33.03, 33.32, 33.74, 34.07, 34.43, 34.8, 34.95, 35.27, 35.6, 35.79, 36.11, 36.48, 36.91, 37.17, 37.42, 37.86, 38.15, 38.33, 38.59, 39.12, 39.28, 39.91, 40.41, 40.65, 41.04, 41.46, 41.79, 42.09, 45.83, 49.7, 53.4, 57.6, 61.63, 65.34, 69.64, 74.11, 78.82, 83.56, 88.61, 94.41, 101.1, 106.54, 111.79, 117.71, 124.34, 131.23, 138.9, 146.74, 153.82, 162.21, 169.84, 178.5, 188.26, 195.82, 204.53, 214.28, 224.28, 234.2, 244.56, 255.51, 267.01, 280.62, 294.67, 308.48, 322.86, 338.28, 355.9, 373.83, 389.9, 408.34, 428.99, 447.39, 466.85, 489.64, 510.39, 534.86, 561.04, 595.06, 619.7, 651.06, 674.86, 708.93, 739.45, 776.98, 819.33, 865.11, 908.28, 969.03, 1018.14, 1080.12, 1142.64, 1203.75, 1269.87, 1356.64, 1431.13, 1534.29, 1626.09, 1722.83, 1817.55, 1932.59, 2085.64, 2227.12, 2414.57, 2616.78, 2840.32, 3085.45, 3346.34, 3671.0, 4058.38, 4519.83, 5060.55, 5693.68, 6367.74, 7399.1, 8498.08, 10480.17, 14411.55]
        self.assertEqual(score_distribution, expected_distribution)

    def test_length(self):
        allele_name = 'DRB1_0101'
        score_distributions = percentile_manager.get_distributions(allele_name)
        distribution = score_distributions[('netmhciipan', 'DRB1_0101', 20)]
        expected_distribution = [8.69, 8.93, 9.42, 9.67, 11.06, 11.08, 11.97, 12.82, 13.58, 13.93, 14.37, 14.48, 14.57, 14.64, 14.73, 15.1, 15.25, 15.33, 15.51, 16.2, 16.29, 16.36, 16.46, 16.51, 16.56, 16.74, 16.81, 17.09, 17.13, 17.56, 17.71, 17.76, 17.76, 17.93, 18.21, 18.32, 18.51, 18.69, 18.88, 18.96, 19.1, 19.37, 19.44, 19.58, 19.59, 20.13, 20.17, 20.76, 21.12, 21.43, 21.68, 21.77, 21.94, 22.2, 22.2, 22.35, 22.46, 22.6, 22.67, 22.72, 22.84, 22.89, 23.0, 23.18, 23.3, 23.35, 23.47, 23.57, 23.83, 23.85, 24.07, 24.48, 24.49, 24.52, 25.06, 25.09, 25.13, 25.22, 25.35, 25.52, 25.62, 25.88, 26.04, 26.06, 26.54, 26.69, 26.85, 26.91, 27.0, 27.16, 27.35, 27.39, 27.43, 27.5, 27.61, 27.62, 27.66, 27.67, 27.67, 27.74, 27.76, 29.14, 29.84, 30.25, 31.95, 32.83, 33.66, 34.06, 34.85, 35.59, 36.39, 37.24, 38.14, 38.99, 39.81, 40.81, 41.76, 42.6, 43.44, 44.2, 44.88, 45.22, 45.93, 47.48, 48.07, 48.75, 49.38, 49.66, 50.37, 50.85, 51.6, 52.0, 52.73, 53.45, 54.38, 55.19, 56.28, 56.68, 57.17, 57.82, 58.39, 59.51, 59.98, 60.56, 61.27, 62.17, 63.41, 64.01, 64.56, 65.23, 65.87, 66.55, 67.49, 68.21, 68.9, 69.47, 70.5, 71.11, 71.66, 72.63, 73.21, 74.24, 74.72, 75.58, 76.28, 77.11, 77.41, 78.12, 78.66, 79.15, 79.85, 80.42, 81.08, 81.82, 82.23, 82.99, 83.8, 84.43, 85.15, 85.61, 86.52, 87.09, 87.86, 88.94, 89.64, 90.8, 91.24, 92.07, 92.7, 93.29, 93.98, 102.21, 109.82, 118.54, 126.44, 133.25, 141.71, 149.2, 158.88, 167.63, 177.16, 185.63, 194.55, 204.33, 215.35, 226.32, 236.46, 245.6, 256.29, 265.99, 277.3, 287.65, 298.56, 313.26, 327.21, 340.16, 354.12, 367.73, 381.84, 395.19, 412.95, 430.27, 447.74, 462.55, 479.0, 497.07, 518.27, 539.7, 559.01, 578.54, 598.38, 620.57, 639.45, 666.56, 688.87, 713.92, 741.66, 769.96, 797.72, 824.26, 849.92, 883.26, 911.34, 944.76, 987.84, 1025.27, 1063.5, 1103.66, 1145.62, 1191.22, 1252.78, 1304.39, 1360.98, 1416.87, 1467.73, 1539.01, 1600.59, 1669.23, 1750.24, 1859.43, 1938.58, 2027.04, 2152.07, 2253.69, 2385.72, 2520.25, 2631.86, 2811.06, 2985.91, 3178.6, 3389.34, 3674.77, 3997.46, 4289.23, 4731.5, 5265.26, 5878.92, 6925.55, 8269.15, 11086.6]
        self.assertEqual(distribution, expected_distribution)

    def test_H2(self):
        allele_name = 'H-2-IAb'
        score_distributions = percentile_manager.get_distributions(allele_name)
        distribution = score_distributions[('netmhciipan', 'H-2-IAb', 20)]
        expected_distribution = [24.4, 35.58, 40.22, 51.37, 54.19, 57.57, 57.59, 65.54, 68.17, 69.86, 70.33, 70.59, 74.37, 77.41, 77.44, 80.86, 82.18, 83.8, 88.05, 92.46, 94.41, 99.19, 99.22, 101.39, 103.66, 104.87, 106.21, 107.08, 110.59, 111.07, 112.57, 112.59, 113.0, 113.03, 113.61, 115.62, 116.88, 117.88, 117.98, 118.18, 119.44, 120.5, 120.89, 120.95, 121.29, 122.46, 123.23, 127.59, 128.61, 132.47, 133.56, 133.69, 134.73, 137.62, 139.84, 140.76, 141.54, 142.82, 145.11, 146.81, 148.25, 148.34, 148.41, 149.14, 151.34, 152.44, 154.43, 157.54, 158.91, 158.99, 159.73, 159.98, 159.99, 161.98, 163.54, 164.48, 164.8, 165.15, 166.69, 166.81, 168.4, 168.69, 168.69, 169.87, 169.89, 170.41, 170.51, 170.8, 171.32, 172.12, 173.43, 173.68, 173.73, 176.59, 180.65, 181.88, 181.92, 182.22, 182.57, 185.27, 185.58, 202.04, 211.22, 216.77, 221.88, 231.01, 246.02, 250.28, 261.4, 272.35, 284.33, 290.34, 297.45, 304.23, 313.78, 324.66, 331.59, 337.94, 343.13, 349.41, 355.88, 361.49, 368.95, 376.27, 382.44, 389.95, 396.49, 401.6, 406.81, 414.64, 422.89, 431.54, 437.97, 449.01, 452.71, 456.53, 465.52, 472.86, 480.49, 485.47, 488.34, 495.49, 501.97, 507.29, 515.31, 521.99, 527.9, 535.62, 545.14, 553.46, 560.47, 565.47, 569.93, 576.02, 582.29, 589.63, 594.34, 601.79, 608.72, 616.9, 623.49, 632.56, 640.16, 648.19, 660.22, 669.79, 677.23, 684.42, 694.2, 697.86, 703.01, 708.73, 716.69, 727.11, 731.72, 743.92, 754.45, 758.15, 762.7, 766.3, 774.17, 784.97, 789.72, 798.49, 806.86, 820.27, 826.24, 831.57, 836.7, 845.48, 851.33, 911.31, 976.05, 1043.0, 1130.78, 1199.4, 1270.3, 1353.09, 1432.43, 1500.56, 1577.94, 1665.12, 1734.48, 1812.96, 1893.78, 1975.77, 2056.27, 2127.16, 2208.31, 2297.09, 2374.96, 2459.9, 2539.99, 2629.75, 2714.37, 2807.56, 2923.35, 3019.99, 3129.23, 3221.4, 3334.78, 3432.93, 3534.16, 3636.21, 3759.23, 3866.69, 3972.88, 4080.27, 4191.73, 4311.47, 4432.99, 4555.23, 4679.62, 4809.96, 4945.85, 5082.56, 5206.17, 5371.66, 5509.33, 5640.1, 5769.78, 5956.33, 6083.86, 6238.78, 6405.61, 6569.22, 6723.83, 6892.43, 7077.81, 7239.77, 7425.16, 7635.61, 7829.53, 8041.25, 8244.58, 8475.04, 8722.03, 8968.54, 9209.07, 9494.89, 9762.94, 10038.55, 10325.97, 10580.32, 10908.12, 11241.57, 11616.35, 12059.46, 12391.06, 12879.04, 13262.56, 13665.32, 14198.27, 14820.16, 15552.69, 16310.13, 17176.05, 18350.9, 19536.66, 22012.09] 
        self.assertEqual(distribution, expected_distribution)
    

    def test_key_error(self):
        allele_name = 'DRB1_0101'
        score_distributions = percentile_manager.get_distributions(allele_name)
        with self.assertRaises(KeyError):
            distribution = score_distributions[('netmhciipan', 'SLA-1*0401', 9)]


if __name__ == '__main__':
    unittest.main()
