import os
from setuptools import setup


# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()


def recursive_walk(startdir):
    file_list = []
    for dirname, subdirList, fileList in os.walk(startdir, followlinks=True):
        for fname in fileList:
            file_list.append(os.path.join(dirname, fname))
            for sdname in subdirList:
                sdfiles = recursive_walk(sdname)
                file_list.extend(sdfiles)
    return file_list

# Collect the paths of all the data files for package_data.
os.chdir('mhcii_netmhciipan_4_3_ba_percentile_data/')
percentile_data_files = recursive_walk('./')
os.chdir(os.pardir)

setup(
    name="mhcii_netmhciipan_4_3_ba_percentile_data",
    version="1.0.0",
    author="Jason Yan",
    author_email="jyan@lji.org",
    packages=['mhcii_netmhciipan_4_3_ba_percentile_data'],
    package_data={
        'mhcii_netmhciipan_4_3_ba_percentile_data': percentile_data_files,
    },
    description='PyPA package to provide template for python packaging.',
    long_description=README,
    # Important only if the package will be widely distributed.  See more at:
    #    https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ]
)
