'''rescaled based on epitope length count frequence over frequency of 15mers'''

epitope_length_frequency_dict = {'43': 0.0003206, '24': 0.0235615, '25': 0.014746, '26': 0.0044879, '27': 0.005129, '20': 0.1293477, '21': 0.0815836, '22': 0.0479243, '23': 0.0349415, '46': 0.0001603, '28': 0.0036865, '29': 0.0035262, '40': 0.0001603, '41': 0.0001603, '3': 0.0001603, '5': 0.0006411, '7': 0.0072127, '6': 0.0009617, '9': 0.0987338, '8': 0.0246834, '38': 0.0001603, '11': 0.175028, '10': 0.1070684, '13': 0.6412887, '12': 0.3372335, '15': 1.0, '14': 0.9286745, '17': 0.5871133, '16': 0.8663247, '19': 0.1945825, '18': 0.3378747, '31': 0.0028851, '30': 0.0019234, '37': 0.0006411, '36': 0.0008014, '35': 0.0003206, '34': 0.0004808, '33': 0.0016028, '32': 0.0025645}


def calculate_length_rescaled(length,rank):
    if not rank:
        return None
    else:
        length = str(length)
        # this is for: if rank == '-': return '-'
        try:
            return '%.2f' % (float(rank) / epitope_length_frequency_dict[length])
        except:
            return rank
