### List of target values vs. predictions produces a scatterplot showing the correlation
## use as: cat scatterplot.tgvspred.R | R-2.9 --vanilla --args [infile] [outfile] [title] [xbin] > $wd/log.txt

cmd_args = commandArgs(TRUE);

datafile = cmd_args[1];
outfile = cmd_args[2];
title = cmd_args[3];
plotbins = as.numeric(cmd_args[4]);

#load data
mat=as.matrix(read.delim(datafile,header=F));

tg=as.numeric(mat[,2]);
pred=as.numeric(mat[,3]);

op <- options(warn = (-1)); 
cor.test(tg,pred,method="pearson")
cor.test(tg,pred,method="spearman")
options(op);

pdf(outfile);
if (plotbins>0) {
   require(grid,quietly=TRUE);
   require(lattice,quietly=TRUE);
   require(hexbin,quietly=TRUE);
   bin=hexbin(pred,tg,xbins=plotbins);
   
   plot(bin, main=title, xlab="prediction", ylab="observed");

} else {

plot(pred,tg,main=title,xlab="prediction",ylab="observed");
}

dev.off();

