'''
Created on Oct 11, 2019
@author: Yan
The code coverage by tests is 100%. (__init__.py)  
'''
from unittest import TestCase
import unittest

from mhci_netmhccons_percentile_data import score_distributions
'''
Name                                                                                                        Stmts   Miss  Cover
-------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/__init__.py                         1607    988    39%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/__init__.py                    0      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__about__.py        10      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__init__.py          3      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_compat.py          12      1    92%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_structures.py      41     17    59%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/specifiers.py      281    201    28%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/version.py         150     78    48%
mhci_netmhccons_percentile_data/__init__.py                                                                     7      0   100%
tests.py                                                                                                       25      0   100%
-------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                        2136   1285    40%
'''
class GetModleDataTests(TestCase):

    def test_H2(self):
        distribution = score_distributions[('netmhccons', 'H-2-Db', 9)]
        expected_distribution = [12.44, 15.61, 16.13, 16.39, 23.68, 36.71, 42.02, 44.6, 46.57, 61.04, 66.2, 80.87, 89.14, 92.08, 92.58, 98.79, 119.38, 134.47, 138.16, 138.16, 138.16, 159.03, 203.96, 228.5, 236.04, 237.32, 239.9, 243.82, 243.82, 251.87, 271.69, 280.65, 283.7, 283.7, 286.79, 291.48, 296.25, 314.41, 316.12, 321.29, 339.15, 361.9, 388.27, 398.91, 401.08, 444.5, 446.91, 469.21, 520.0, 534.26, 534.26, 537.16, 537.16, 545.95, 595.31, 601.78, 645.63, 688.93, 700.21, 747.17, 767.66, 878.83, 898.05, 937.77, 953.12, 979.25, 995.27, 1011.56, 1067.79, 1085.26, 1097.07, 1127.15, 1145.59, 1189.81, 1196.26, 1215.83, 1222.43, 1276.5, 1376.93, 1422.36, 1509.57, 1534.27, 1584.89, 1593.49, 1691.19, 1691.19, 1728.19, 1737.56, 1775.57, 1775.57, 1804.62, 1814.41, 1864.16, 1874.27, 1894.66, 1925.66, 1936.11, 1957.17, 1967.79, 1999.98, 1999.98, 2204.54, 2579.01, 2737.14, 3099.81, 3272.12, 3587.33, 4018.93, 4242.33, 4454.0, 4576.12, 4883.05, 5238.84, 5470.55, 5620.54, 5997.52, 6229.0, 6469.41, 6719.1, 7131.08, 7527.49, 7692.16, 7903.07, 8163.8, 8433.14, 8617.62, 8806.13, 8998.77, 9195.62, 9346.08, 9447.76, 9602.34, 9919.14, 10191.11, 10470.53, 10757.62, 11052.58, 11233.42, 11417.23, 11541.43, 11793.9, 12051.9, 12315.54, 12653.21, 12790.86, 13070.67, 13284.53, 13501.89, 13648.77, 13797.25, 14023.0, 14175.55, 14329.76, 14564.23, 14882.82, 15044.73, 15208.39, 15373.84, 15541.08, 15625.39, 15967.2, 16140.9, 16316.49, 16493.98, 16673.41, 16854.8, 17130.58, 17316.93, 17505.31, 17791.74, 17985.29, 18180.94, 18378.72, 18578.65, 18780.76, 18985.07, 19191.6, 19191.6, 19400.38, 19611.42, 19824.77, 20040.43, 20149.14, 20258.44, 20478.82, 20589.91, 20701.6, 20813.9, 21040.32, 21269.21, 21500.59, 22818.9, 23957.42, 25017.04, 26123.53, 27278.95, 28178.94, 29266.51, 30232.07, 31060.99, 31740.46, 32434.8, 33144.32, 33869.37, 34610.27, 35367.39, 35752.13, 36337.11, 36931.66, 37535.94, 38150.11, 38565.12, 38984.65, 39408.75, 39837.46, 40270.83, 40489.28, 40929.75, 41375.0, 41599.44, 41825.1, 42280.1, 42509.45, 42740.04, 42971.89, 43204.99, 43439.36, 43675.0, 43911.91, 44150.12, 44389.61, 44389.61, 44630.4, 44872.5, 44872.5, 45115.92, 45360.65, 45360.65, 45606.71, 45606.71, 45854.11, 45854.11, 46102.85, 46102.85, 46352.93, 46352.93, 46604.38, 46604.38, 46604.38, 46857.18, 46857.18, 47111.36, 47111.36, 47111.36, 47366.92, 47366.92, 47366.92, 47623.87, 47623.87, 47623.87, 47882.2, 47882.2, 47882.2, 48141.94, 48141.94, 48141.94, 48403.09, 48403.09, 48403.09, 48403.09, 48665.66, 48665.66, 48665.66, 48929.64, 48929.64, 48929.64, 49195.07, 49195.07, 49461.93, 49461.93]
        self.assertEqual(distribution, expected_distribution)

    def test_HLA(self):
        distribution = score_distributions[('netmhccons', 'HLA-A02:01', 9)]
        expected_distribution = [2.19, 2.26, 2.89, 2.92, 3.02, 3.93, 4.36, 4.4, 4.52, 4.75, 4.88, 4.88, 4.88, 5.01, 5.21, 5.24, 5.29, 5.62, 5.87, 6.03, 6.4, 6.94, 7.16, 7.6, 7.81, 7.94, 8.07, 8.34, 8.47, 8.71, 9.09, 9.44, 9.65, 9.7, 9.75, 9.91, 9.97, 10.07, 10.35, 10.58, 10.87, 11.29, 11.72, 11.85, 12.31, 12.31, 13.13, 13.57, 13.71, 13.86, 13.94, 14.01, 14.4, 14.48, 14.63, 14.87, 15.03, 15.36, 15.78, 16.04, 16.75, 16.84, 16.93, 17.78, 17.88, 18.57, 18.97, 19.18, 19.39, 19.39, 19.49, 19.6, 19.6, 19.6, 19.92, 20.47, 20.58, 21.96, 22.19, 23.43, 23.68, 24.2, 24.33, 24.47, 24.47, 24.6, 24.6, 25.0, 25.14, 25.97, 26.53, 27.41, 28.16, 28.31, 29.73, 29.73, 30.38, 30.38, 31.38, 31.89, 32.41, 37.31, 42.25, 48.9, 53.32, 62.04, 66.56, 73.37, 77.44, 83.54, 92.58, 100.41, 113.71, 124.66, 141.95, 160.76, 171.54, 178.16, 196.38, 216.47, 230.98, 258.77, 273.16, 302.73, 316.12, 340.99, 373.84, 394.62, 432.64, 469.21, 500.68, 543.0, 567.02, 605.05, 645.63, 681.52, 735.14, 771.82, 814.73, 846.17, 907.82, 973.97, 1033.69, 1067.79, 1115.02, 1164.33, 1202.75, 1262.76, 1325.76, 1362.11, 1469.28, 1501.43, 1559.37, 1663.96, 1804.62, 1894.66, 1967.79, 2043.73, 2099.77, 2169.05, 2264.98, 2327.08, 2430.01, 2537.49, 2621.2, 2707.68, 2781.92, 2889.29, 3017.08, 3066.45, 3167.62, 3272.12, 3416.85, 3491.59, 3567.97, 3665.8, 3725.78, 3807.28, 3890.57, 4018.93, 4129.12, 4219.45, 4335.14, 4478.16, 4526.88, 4625.9, 4701.59, 4778.52, 4936.17, 5016.94, 5154.5, 6229.0, 7446.48, 8571.13, 9812.39, 10874.65, 11857.88, 13000.15, 14023.0, 15044.73, 15795.37, 16763.86, 17505.31, 18279.56, 19088.05, 19824.77, 20478.82, 21154.46, 21852.38, 22451.54, 23067.13, 23571.74, 24087.38, 24614.3, 25017.04, 25426.37, 25842.4, 26265.23, 26694.99, 27131.77, 27426.93, 27875.69, 28178.94, 28640.0, 28951.56, 29266.51, 29425.27, 29745.37, 30068.96, 30232.07, 30560.95, 30726.73, 31060.99, 31229.48, 31398.89, 31740.46, 31912.64, 32085.75, 32259.8, 32434.8, 32610.74, 32787.64, 32965.5, 33144.32, 33324.12, 33504.88, 33686.63, 33869.37, 34053.09, 34053.09, 34237.82, 34423.54, 34423.54, 34610.27, 34798.02, 34986.78, 35176.57, 35176.57, 35367.39, 35559.24, 35752.13, 35752.13, 35946.07, 36141.06, 36141.06, 36337.11, 36534.22, 36534.22, 36732.4, 36931.66, 37132.0, 37132.0, 37333.42, 37535.94, 37739.56, 37944.28, 38150.11, 38357.05, 38774.32, 39196.13] 
        self.assertEqual(distribution, expected_distribution)

    def test_Mamu(self):
        distribution = score_distributions[('netmhccons', 'Mamu-A1:00102', 9)]
        expected_distribution = [2.43, 3.08, 3.38, 3.85, 3.99, 4.99, 5.73, 6.13, 7.0, 7.31, 8.37, 8.4, 9.08, 10.76, 12.92, 13.81, 14.01, 17.29, 18.69, 18.82, 19.25, 19.72, 19.93, 20.28, 20.82, 22.19, 22.32, 22.79, 22.83, 23.0, 23.84, 25.48, 26.03, 27.68, 28.92, 29.04, 29.75, 31.58, 32.68, 32.96, 33.64, 34.3, 35.19, 35.28, 35.49, 35.75, 36.34, 36.49, 37.12, 38.26, 38.95, 39.68, 39.9, 39.97, 40.22, 46.73, 49.97, 51.73, 51.95, 54.01, 54.69, 56.55, 56.58, 58.01, 58.33, 58.43, 59.04, 60.08, 61.33, 61.73, 62.03, 62.16, 63.24, 67.52, 68.83, 69.35, 70.38, 73.28, 74.69, 75.88, 76.71, 77.32, 78.04, 79.45, 80.18, 80.44, 81.96, 82.25, 82.95, 85.21, 87.68, 87.72, 88.52, 90.97, 91.34, 94.25, 94.34, 96.03, 96.55, 97.39, 99.49, 110.83, 118.75, 135.3, 154.58, 173.68, 191.85, 211.97, 236.15, 264.04, 284.51, 294.66, 320.05, 330.11, 357.22, 388.47, 415.35, 431.24, 467.19, 502.89, 535.35, 571.12, 608.97, 652.77, 687.32, 729.04, 768.55, 801.6, 825.29, 871.26, 898.57, 927.29, 961.24, 1003.74, 1031.98, 1072.43, 1159.19, 1221.11, 1270.89, 1312.7, 1374.12, 1416.87, 1493.07, 1574.7, 1614.29, 1654.84, 1694.85, 1753.63, 1798.17, 1851.06, 1931.73, 1997.11, 2073.02, 2131.61, 2202.53, 2278.55, 2321.9, 2389.23, 2449.81, 2517.17, 2538.45, 2593.25, 2705.78, 2815.51, 2898.84, 2957.87, 3035.85, 3106.59, 3186.28, 3229.39, 3328.58, 3437.99, 3491.21, 3570.48, 3716.16, 3750.57, 3846.37, 3867.78, 3955.38, 4060.49, 4141.06, 4201.95, 4265.9, 4340.49, 4423.07, 4503.33, 4567.81, 4650.29, 4689.3, 4775.83, 4840.55, 5549.18, 6388.03, 7160.54, 7920.01, 8883.17, 9786.1, 10634.03, 11492.33, 12331.8, 13182.3, 13994.35, 15013.34, 15789.73, 16699.05, 17578.19, 18495.21, 19283.81, 19999.28, 20740.17, 21580.76, 22404.96, 23082.61, 23837.71, 24538.79, 25230.98, 25882.13, 26546.65, 27120.33, 27770.04, 28380.27, 28868.68, 29407.77, 29985.46, 30494.89, 31028.75, 31485.99, 32020.9, 32474.12, 32985.48, 33386.19, 33842.27, 34271.16, 34732.57, 35150.71, 35563.07, 35920.02, 36325.72, 36717.31, 37163.75, 37483.6, 37890.11, 38263.78, 38581.4, 38951.76, 39347.39, 39650.82, 40031.89, 40373.35, 40699.68, 41021.96, 41384.4, 41669.27, 41927.95, 42247.17, 42509.45, 42800.19, 43096.2, 43411.18, 43693.43, 43962.31, 44214.65, 44484.34, 44723.69, 44976.52, 45204.85, 45431.38, 45668.44, 45927.11, 46229.71, 46448.32, 46681.59, 46912.98, 47128.71, 47372.54, 47565.16, 47816.96, 48051.41, 48366.45, 48762.11]
        self.assertEqual(distribution, expected_distribution)

    def test_SLA(self):
        distribution = score_distributions[('netmhccons', 'SLA-1:1301', 9)]
        expected_distribution = [171.54, 188.06, 201.76, 210.69, 222.4, 234.76, 253.23, 257.38, 265.87, 267.31, 273.16, 276.13, 277.63, 285.24, 288.34, 291.48, 294.65, 297.86, 312.72, 319.56, 323.04, 324.79, 330.1, 339.15, 350.34, 352.24, 359.95, 384.09, 392.49, 396.76, 398.91, 409.85, 412.08, 416.56, 427.98, 439.71, 454.22, 476.88, 487.32, 500.68, 508.87, 511.63, 525.66, 534.26, 540.07, 543.0, 548.91, 551.89, 551.89, 567.02, 582.56, 588.9, 605.05, 605.05, 608.33, 625.01, 635.24, 635.24, 638.68, 645.63, 649.13, 649.13, 659.75, 666.93, 670.55, 670.55, 674.19, 677.84, 681.52, 700.21, 700.21, 707.82, 711.66, 715.52, 715.52, 727.23, 731.18, 735.14, 739.13, 759.4, 763.52, 767.66, 771.82, 771.82, 776.01, 780.22, 780.22, 784.45, 784.45, 801.61, 810.33, 814.73, 819.15, 823.59, 837.07, 850.76, 855.38, 855.38, 878.83, 888.39, 888.39, 963.49, 1022.56, 1050.6, 1127.15, 1189.81, 1269.61, 1311.49, 1362.11, 1399.46, 1445.63, 1493.32, 1517.76, 1567.83, 1663.96, 1700.36, 1728.19, 1765.99, 1814.41, 1864.16, 1936.11, 1967.79, 1989.19, 2021.74, 2088.44, 2157.34, 2204.54, 2252.76, 2289.62, 2365.16, 2403.86, 2430.01, 2510.18, 2537.49, 2593.0, 2635.42, 2722.37, 2766.91, 2858.2, 2873.7, 2936.57, 2952.5, 2984.62, 3049.9, 3083.08, 3099.81, 3167.62, 3219.45, 3254.47, 3343.7, 3361.84, 3416.85, 3472.75, 3510.53, 3548.72, 3626.35, 3665.8, 3705.68, 3745.99, 3786.74, 3827.94, 3848.7, 3890.57, 3932.89, 3954.23, 3997.24, 4040.73, 4062.65, 4106.84, 4151.52, 4196.68, 4242.33, 4288.48, 4311.75, 4358.65, 4382.3, 4429.97, 4454.0, 4502.45, 4526.88, 4576.12, 4600.95, 4625.9, 4651.0, 4727.1, 4804.44, 4856.71, 4883.05, 4909.54, 4936.17, 4962.95, 5353.44, 5712.5, 6095.65, 6504.5, 6792.19, 7131.08, 7446.48, 7775.84, 8163.8, 8478.89, 8853.9, 9146.01, 9499.0, 9919.14, 10191.11, 10527.33, 10874.65, 11172.82, 11541.43, 11857.88, 12183.0, 12584.95, 13000.15, 13284.53, 13648.77, 13947.35, 14329.76, 14722.66, 15208.39, 15625.39, 15967.2, 16404.99, 16763.86, 17130.58, 17600.27, 18082.85, 18578.65, 18985.07, 19505.61, 19932.31, 20368.33, 20813.9, 21269.21, 21734.48, 22209.93, 22695.78, 23192.26, 23699.6, 24218.04, 24747.82, 25289.19, 25842.4, 26407.71, 26839.8, 27426.93, 28026.9, 28795.36, 29425.27, 30068.96, 30560.95, 31229.48, 31912.64, 32434.8, 33144.32, 33504.88, 34237.82, 34610.27, 35176.57, 35752.13, 36534.22, 36931.66, 37739.56, 38150.11, 38774.32, 39408.75, 39837.46, 40489.28, 40929.75, 41599.44, 42051.98, 42509.45, 42971.89, 43439.36, 43911.91, 44389.61, 45115.92, 45606.71, 46352.93, 47111.36]
        self.assertEqual(distribution, expected_distribution)

    def test_key_error(self):
        with self.assertRaises(KeyError):
            distribution = score_distributions[('ann', 'SLA-1*0401', 9)]


if __name__ == '__main__':
    unittest.main()
