'''
Created on Sep 30, 2019
@author: Yan
Run this test after the package being installed because of the path need to be reset.
'''
from unittest import TestCase
import unittest

from netmhccons_1_1_executable import predict_sequence #, parse_pickpocket_output, predict_peptide_list, strip_allele_name
'''
$ coverage report
Name                                                                                                                      Stmts   Miss  Cover
---------------------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/allele_info/__init__.py                                            1      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/allele_info/allele_info.py                                       262    202    23%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/iedbtools_utilities/__init__.py                                    0      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/iedbtools_utilities/sequence_io.py                                86     69    20%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/iedbtools_utilities/sequence_manipulation.py                       7      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/netmhccons_1_1_executable/__init__.py                              1      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/netmhccons_1_1_executable/netmhccons_1_1_python_interface.py      70     14    80%
tests.py                                                                                                                     27      0   100%
---------------------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                                       454    285    37%

'''

class PredictSequenceTests(TestCase):

    def test_H2(self):
        sequence = 'SLYNTVATLYCVHQRIDV'
        allele_length_pair = ('H-2-Db', 9)
        scores = predict_sequence(sequence, allele_length_pair)
        self.assertEqual(scores, (8163.8, 40053.56, 38984.65, 17600.27, 44150.12, 45115.92, 42280.1, 24882.07, 48141.94, 35946.07))

    def test_HLA(self):
        sequence = 'SLYNTVATLYCVHQRIDV'
        allele_length_pair = ('HLA-A*01:01', 9)
        scores = predict_sequence(sequence, allele_length_pair)
        self.assertEqual(scores, (24481.5, 9812.39, 23192.26, 10992.95, 20701.6, 29425.27, 25426.37, 24481.5, 32787.64, 26839.8))

    def test_Mamu(self):
        sequence = 'SLYNTVATLYCVHQRIDV'
        allele_length_pair = ('Mamu-A1*00102', 9)
        scores = predict_sequence(sequence, allele_length_pair)
        self.assertEqual(scores, (5353.96, 11525.33, 22923.33, 455.18, 21970.45, 26909.59, 14569.59, 6253.99, 42520.94, 31125.59))

    # TODO: One test failed in python 3. Need to check methods one by one.
    def test_SLA(self):
        sequence = 'SLYNTVATLYCVHQRIDV'
        allele_length_pair = ('SLA-1*0101', 9)
        scores = predict_sequence(sequence, allele_length_pair)
        self.assertEqual(scores, (2904.96, 19932.31, 20478.82, 2032.71, 13070.67, 21384.59, 15373.84, 6296.76, 47623.87, 26985.39))

if __name__ == '__main__':
    unittest.main()
