"""
created on 11/19/2019
@author: Yan
"""
from unittest import TestCase
from pickpocket_1_1_executable import predict_single

class PickpocketExecutableTest(TestCase):
    '''test cases for pickpocket'''
    def test_basic(self):
        allele_name = 'HLA-A*02:01'
        binding_length = 9
        sequence = "SLYNTVATLYCVHQRIDV"
        allele_length_2tuple = (allele_name, binding_length)
        results = predict_single(sequence, allele_length_2tuple)
        print('Results:\n{}'.format(results))
        expected_scores = (18.768124303954856, 50000.0, 22209.93328550318, 113.09668929084349, 32787.64122076024, 50000.0, 10757.621596058183, 80.86895325483759, 50000.0, 3133.5287466619466)

        self.assertEqual(expected_scores, results)

    def test_SLA(self):
        sequence = 'SLYNTVATLYCVHQRIDV'
        allele_length_2tuple = ('SLA-1*0101', 9)
        results = predict_single(sequence, allele_length_2tuple)
        print('Results:\n{}'.format(results))
        expected_scores = (1121.0669072114465, 25289.188528449853, 16404.99468020095, 2145.7036159277955, 7446.484392361988, 15541.081711348315, 9654.42834743743, 4062.6458292605503, 50000.0, 22209.93328550318)
        self.assertEqual(expected_scores, results)

