from __future__ import print_function
import os
from setuptools import setup, find_packages
from subprocess import Popen, PIPE
import subprocess
import sys

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

# README file
with open('README.rst', 'r') as rmf:
    README = rmf.read()

setup(
    name = "mhci-ann-predictor-percentile-data",
    version = "3.0.1",
    author = "Dorjee Gyaltsen",
    packages = ['mhci_ann_predictor_percentile_data'],
    package_data = {
        'mhci_ann_predictor_percentile_data': [
            'requirements.txt',
            'ann_percentile_distribution_2019-06-06.p'
        ],
    },
    test_suite = 'tests',
    install_requires = ['netmhc-4.0-executable>=4.0.1'],
    description = 'Percentile data for mhci ANNPredictor',
    long_description = README,
    classifiers = [
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ],
)
