from __future__ import print_function
import os
from setuptools import setup, find_packages
from subprocess import Popen, PIPE
import subprocess
import sys

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

# README file
with open('README.rst', 'r') as rmf:
    README = rmf.read()

setup(
    name = "mhci-netmhcstabpan-predictor-percentile-data",
    version = "1.0.1",
    author = "Jason Yan",
    author_email = "jyan@lji.org",
    packages = ['mhci_netmhcstabpan_predictor_percentile_data'],
    package_data = {
        'mhci_netmhcstabpan_predictor_percentile_data': [
            'requirements.txt',
            'netmhcstabpan_percentile_distribution_2017-11-20.p'
        ],
    },
    test_suite = 'tests',
    description = 'Percentile data for mhci NetMHCStabPanPredictor',
    long_description = README,
    classifiers = [
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ],
)
