'''
Created on Oct 9, 2019
@author: Yan
The code coverage by tests is 100%. (__init__.py)  
'''
from unittest import TestCase
import unittest

from mhci_netmhcstabpan_predictor_percentile_data import score_distributions

'''
Name                                                                                                                Stmts   Miss  Cover
---------------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/__init__.py                          1553    897    42%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/__init__.py                     0      0   100%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/appdirs.py                    250    219    12%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__about__.py         10      0   100%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__init__.py           3      0   100%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_compat.py           12      1    92%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_structures.py       41     17    59%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/markers.py          130     73    44%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/requirements.py      72     25    65%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/specifiers.py       284    202    29%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/version.py          150     50    67%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/pyparsing.py                 2533   1419    44%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/_vendor/six.py                        444    204    54%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/extern/__init__.py                     35      6    83%
/home/jyan/.virtualenvs/python2.7-env/lib/python2.7/site-packages/pkg_resources/py31compat.py                          12      5    58%
mhci_netmhcstabpan_predictor_percentile_data/__init__.py                                                                7      0   100%
tests.py                                                                                                               26      0   100%
---------------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                                5562   3118    44%
'''	
class GetModleDataTests(TestCase):

    def test_H2(self):
        distribution = score_distributions[('netmhcstabpan', 'H-2-Db', 9)]
        expected_distribution = [0.7, 0.53, 0.5, 0.48, 0.45, 0.44, 0.42, 0.41, 0.4, 0.39, 0.38, 0.38, 0.37, 0.36, 0.36, 0.36, 0.35, 0.35, 0.34, 0.34, 0.34, 0.33, 0.33, 0.32, 0.32, 0.32, 0.32, 0.31, 0.31, 0.31, 0.31, 0.3, 0.3, 0.3, 0.3, 0.3, 0.29, 0.29, 0.29, 0.29, 0.28, 0.28, 0.28, 0.28, 0.28, 0.28, 0.27, 0.27, 0.27, 0.27, 0.27, 0.27, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.21, 0.21, 0.21, 0.21, 0.2, 0.19, 0.19, 0.18, 0.18, 0.17, 0.17, 0.17, 0.16, 0.16, 0.15, 0.15, 0.15, 0.15, 0.14, 0.14, 0.14, 0.14, 0.14, 0.13, 0.13, 0.13, 0.13, 0.13, 0.12, 0.12, 0.12, 0.12, 0.12, 0.12, 0.11, 0.11, 0.11, 0.11, 0.11, 0.11, 0.11, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.05, 0.05, 0.05]
        self.assertEqual(distribution, expected_distribution)

    def test_HLA(self):
        distribution = score_distributions[('netmhcstabpan', 'HLA-A02:01', 9)]
        expected_distribution = [39.87, 11.55, 8.48, 6.37, 5.26, 4.63, 4.27, 3.78, 3.57, 3.4, 3.18, 2.99, 2.82, 2.69, 2.56, 2.42, 2.3, 2.19, 2.08, 2.0, 1.93, 1.83, 1.76, 1.68, 1.63, 1.56, 1.52, 1.48, 1.44, 1.38, 1.35, 1.31, 1.27, 1.23, 1.2, 1.18, 1.15, 1.11, 1.06, 1.04, 1.02, 1.0, 0.98, 0.97, 0.95, 0.92, 0.9, 0.88, 0.86, 0.85, 0.83, 0.82, 0.81, 0.79, 0.78, 0.77, 0.76, 0.74, 0.72, 0.71, 0.7, 0.69, 0.68, 0.67, 0.66, 0.65, 0.64, 0.63, 0.63, 0.62, 0.61, 0.6, 0.59, 0.59, 0.57, 0.57, 0.56, 0.55, 0.54, 0.54, 0.53, 0.52, 0.52, 0.51, 0.51, 0.5, 0.5, 0.49, 0.49, 0.48, 0.48, 0.48, 0.47, 0.47, 0.46, 0.46, 0.46, 0.45, 0.45, 0.45, 0.44, 0.41, 0.38, 0.36, 0.33, 0.31, 0.29, 0.28, 0.27, 0.26, 0.25, 0.24, 0.23, 0.22, 0.22, 0.21, 0.2, 0.2, 0.19, 0.19, 0.18, 0.18, 0.18, 0.17, 0.17, 0.16, 0.16, 0.16, 0.15, 0.15, 0.15, 0.14, 0.14, 0.14, 0.14, 0.13, 0.13, 0.13, 0.13, 0.13, 0.12, 0.12, 0.12, 0.12, 0.12, 0.12, 0.11, 0.11, 0.11, 0.11, 0.11, 0.11, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.06, 0.06, 0.06, 0.06, 0.06, 0.05]
        self.assertEqual(distribution, expected_distribution)

    def test_Mamu(self):
        distribution = score_distributions[('netmhcstabpan', 'Mamu-A2:0102', 9)]
        expected_distribution = [0.59, 0.41, 0.38, 0.36, 0.36, 0.34, 0.33, 0.32, 0.32, 0.31, 0.31, 0.3, 0.3, 0.29, 0.29, 0.29, 0.29, 0.28, 0.28, 0.28, 0.28, 0.28, 0.27, 0.27, 0.27, 0.27, 0.27, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.19, 0.19, 0.18, 0.18, 0.17, 0.17, 0.17, 0.16, 0.16, 0.16, 0.15, 0.15, 0.15, 0.15, 0.14, 0.14, 0.14, 0.14, 0.13, 0.13, 0.13, 0.13, 0.13, 0.12, 0.12, 0.12, 0.12, 0.12, 0.12, 0.11, 0.11, 0.11, 0.11, 0.11, 0.11, 0.11, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.05, 0.05, 0.05, 0.05, 0.0]
        self.assertEqual(distribution, expected_distribution)

    def test_SLA(self):
        distribution = score_distributions[('netmhcstabpan', 'SLA-1:0401', 9)]
        expected_distribution = [0.59, 0.49, 0.45, 0.43, 0.42, 0.4, 0.4, 0.38, 0.37, 0.36, 0.35, 0.35, 0.35, 0.34, 0.34, 0.34, 0.33, 0.33, 0.32, 0.32, 0.32, 0.31, 0.31, 0.31, 0.3, 0.3, 0.3, 0.29, 0.29, 0.29, 0.29, 0.28, 0.28, 0.28, 0.28, 0.28, 0.28, 0.27, 0.27, 0.27, 0.27, 0.27, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.24, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.23, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.22, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.2, 0.2, 0.19, 0.19, 0.18, 0.18, 0.18, 0.17, 0.17, 0.16, 0.16, 0.16, 0.16, 0.15, 0.15, 0.15, 0.14, 0.14, 0.14, 0.14, 0.14, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.12, 0.12, 0.12, 0.12, 0.12, 0.12, 0.11, 0.11, 0.11, 0.11, 0.11, 0.11, 0.11, 0.11, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.06, 0.06, 0.06, 0.06, 0.06, 0.05]
        self.assertEqual(distribution, expected_distribution)

    def test_key_error(self):
        with self.assertRaises(KeyError):
            distribution = score_distributions[('ann', 'SLA-1*0401', 9)]


if __name__ == '__main__':
    unittest.main()
