"""
created on 05/26/2017
@author: dorjee
"""

from unittest import TestCase

from netmhc_3_4_executable import predict as netmhc_predict


class NetMHCExecutableTest(TestCase):

    def basic_test(self):
        allele_name = 'HLA-A*02:01'
        binding_length = '9'
        sequence = "SLYNTVATLYCVHQRIDV"

        results = netmhc_predict(allele_name, binding_length, sequence)
        print('Results:\n{}'.format(results))
        expected_scores = (94.0, 26107.0, 23606.0, 254.0, 29834.0, 25539.0, 18814.0, 303.0, 29230.0, 13053.0)

        for score in expected_scores:
            self.assertIn(score, results)
