"""
created on 11/18/2019
@author: Yan
"""
from unittest import TestCase
from netmhcpan_2_8_executable import predict_many

class NetMHCpanExecutableTest(TestCase):
    '''test cases for netmhcpan 2.8'''
    def test_basic(self):
        allele_name = 'HLA-A*02:01'
        binding_length = '9'
        sequence = "SLYNTVATLYCVHQRIDV"

        sequence_list = [sequence,]
        allele_length_2tuple_list = [(allele_name, binding_length),]

        results = predict_many(sequence_list, allele_length_2tuple_list)
        print('Results:\n{}'.format(results))
        scores = list(results.values())
        expected_scores = [[256.45, 32612.15, 34977.69, 119.82, 35985.76, 38703.06, 24344.15, 306.28, 45527.82, 23619.98],]

        self.assertEqual(expected_scores, scores)

    def test_SLA(self):
        sequence = 'SLYNTVATLYCVHQRIDV'
        allele_name = 'SLA-1*0101'
        binding_length = '9'
        sequence_list = [sequence,]
        allele_length_2tuple_list = [(allele_name, binding_length),]

        results = predict_many(sequence_list, allele_length_2tuple_list)
        print('Results:\n{}'.format(results))
        scores = list(results.values())
        expected_scores = [[7502.28, 15790.92, 25681.3, 1933.14, 23016.03, 29343.25, 24432.81, 9743.84, 45163.3, 32704.38],]
        self.assertEqual(expected_scores, scores)
